/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import jgamebase.Const;
import jgamebase.db.Db;
import jgamebase.db.model.Extra;
import jgamebase.db.model.Game;
import jgamebase.db.model.Item;
import jgamebase.db.model.ItemView;
import jgamebase.db.model.Music;
import jgamebase.model.Databases;
import jgamebase.model.Paths;
import jgamebase.tools.ListerTools;

public class VerifyAvailableFilesDialog
extends JDialog {
    private static final long serialVersionUID = -211835818560997806L;
    private static final int STATUS_STOPPED = 1;
    private static final int STATUS_RUNNING = 2;
    private static final String MISSING_FILE_LIST_EXTENSION = "mfl";
    private int status = 1;
    private File file;
    private PrintWriter out;
    private JCheckBox extrasCheckBox;
    private JLabel extrasLabel;
    private JCheckBox gamesCheckBox;
    private JLabel gamesLabel;
    private JCheckBox musicCheckBox;
    private JLabel musicLabel;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JCheckBox screenshotsCheckBox;
    private JLabel screenshotsLabel;
    private JButton startButton;

    public VerifyAvailableFilesDialog() {
        this.initComponents();
        try {
            this.setVisible(true);
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JPanel mainPanel = new JPanel();
        this.gamesCheckBox = new JCheckBox();
        this.gamesLabel = new JLabel();
        this.musicCheckBox = new JCheckBox();
        this.musicLabel = new JLabel();
        this.screenshotsCheckBox = new JCheckBox();
        this.screenshotsLabel = new JLabel();
        this.extrasCheckBox = new JCheckBox();
        this.extrasLabel = new JLabel();
        JPanel buttonPanel = new JPanel();
        this.progressLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.startButton = new JButton();
        JButton cancelButton = new JButton();
        this.setTitle("Verify Available Files...");
        this.setMinimumSize(new Dimension(580, 200));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                VerifyAvailableFilesDialog.this.exitFormWindowClosing(evt);
            }
        });
        jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel1.setLayout(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createTitledBorder(""));
        mainPanel.setLayout(new GridBagLayout());
        this.gamesCheckBox.setSelected(true);
        this.gamesCheckBox.setText("Games");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        mainPanel.add((Component)this.gamesCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        mainPanel.add((Component)this.gamesLabel, gridBagConstraints);
        this.musicCheckBox.setSelected(true);
        this.musicCheckBox.setText("Music");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        mainPanel.add((Component)this.musicCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        mainPanel.add((Component)this.musicLabel, gridBagConstraints);
        this.screenshotsCheckBox.setSelected(true);
        this.screenshotsCheckBox.setText("Screenshots");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        mainPanel.add((Component)this.screenshotsCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        mainPanel.add((Component)this.screenshotsLabel, gridBagConstraints);
        this.extrasCheckBox.setSelected(true);
        this.extrasCheckBox.setText("Extras");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        mainPanel.add((Component)this.extrasCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        mainPanel.add((Component)this.extrasLabel, gridBagConstraints);
        jPanel1.add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)jPanel1, "North");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPanel.setLayout(new GridBagLayout());
        this.progressLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        buttonPanel.add((Component)this.progressLabel, gridBagConstraints);
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        buttonPanel.add((Component)this.progressBar, gridBagConstraints);
        this.startButton.setMnemonic('O');
        this.startButton.setText("Start");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VerifyAvailableFilesDialog.this.startActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        buttonPanel.add((Component)this.startButton, gridBagConstraints);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VerifyAvailableFilesDialog.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        buttonPanel.add((Component)cancelButton, gridBagConstraints);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void cancel() {
        if (this.status == 1) {
            this.dispose();
        }
        this.status = 1;
        this.startButton.setEnabled(true);
    }

    private void startActionPerformed(ActionEvent evt) {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                VerifyAvailableFilesDialog.this.status = 2;
                VerifyAvailableFilesDialog.this.startButton.setEnabled(false);
                VerifyAvailableFilesDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    try {
                        VerifyAvailableFilesDialog.this.file = new File(Databases.getCurrent().getPath(), "VerifyAvailableFiles.log");
                        VerifyAvailableFilesDialog.this.out = new PrintWriter(new FileWriter(VerifyAvailableFilesDialog.this.file));
                        VerifyAvailableFilesDialog.this.out.println(new SimpleDateFormat("EEEE dd MMMM yyyy HH:mm:ss").format(new Date()));
                        VerifyAvailableFilesDialog.this.out.println();
                        VerifyAvailableFilesDialog.this.out.println("DATABASE PATH");
                        VerifyAvailableFilesDialog.this.out.println("  " + Databases.getCurrent().getPath());
                        VerifyAvailableFilesDialog.this.out.println();
                        VerifyAvailableFilesDialog.this.out.println();
                        if (VerifyAvailableFilesDialog.this.gamesCheckBox.isSelected() && VerifyAvailableFilesDialog.this.status == 2) {
                            VerifyAvailableFilesDialog.this.verifyGames();
                        }
                        if (VerifyAvailableFilesDialog.this.musicCheckBox.isSelected() && VerifyAvailableFilesDialog.this.status == 2) {
                            VerifyAvailableFilesDialog.this.verifyMusic();
                        }
                        if (VerifyAvailableFilesDialog.this.screenshotsCheckBox.isSelected() && VerifyAvailableFilesDialog.this.status == 2) {
                            VerifyAvailableFilesDialog.this.verifyScreenshots();
                        }
                        if (VerifyAvailableFilesDialog.this.extrasCheckBox.isSelected() && VerifyAvailableFilesDialog.this.status == 2) {
                            VerifyAvailableFilesDialog.this.verifyExtras();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (VerifyAvailableFilesDialog.this.out != null) {
                            VerifyAvailableFilesDialog.this.out.close();
                        }
                        this.done();
                    }
                }
                finally {
                    if (VerifyAvailableFilesDialog.this.out != null) {
                        VerifyAvailableFilesDialog.this.out.close();
                    }
                    this.done();
                }
                return null;
            }

            @Override
            protected void done() {
                VerifyAvailableFilesDialog.this.status = 1;
                VerifyAvailableFilesDialog.this.startButton.setEnabled(true);
                VerifyAvailableFilesDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }.execute();
    }

    private void verifyGames() {
        int completeListSize;
        List<Item> list;
        ArrayList<Game> notFound;
        block14: {
            File missingFileList = new File(new File(Const.GBDIR_RW, Databases.getCurrent().getName()), "games.mfl");
            PrintWriter missing = null;
            missingFileList.delete();
            this.status = 2;
            notFound = new ArrayList<Game>();
            this.gamesLabel.setText("");
            this.progressBar.setIndeterminate(true);
            this.out.println("VERIFY GAMES");
            this.out.println("Paths:");
            ListerTools.fileListToStringList(Paths.getGamePath().getWithDefault()).forEach(path -> this.out.println("  " + path));
            this.out.println();
            this.progressLabel.setText("Loading games...");
            ItemView view = new ItemView();
            view.setInclude(0);
            list = Db.getItems(view);
            completeListSize = list.size();
            this.gamesLabel.setText(String.valueOf(list.size()) + " games loaded.");
            Iterator<Item> iter = list.iterator();
            while (iter.hasNext()) {
                Game game2 = (Game)iter.next();
                if (!game2.getFilename().isEmpty()) continue;
                iter.remove();
            }
            this.gamesLabel.setText("Searching for " + list.size() + " of " + completeListSize + " games.");
            this.progressBar.setIndeterminate(false);
            this.progressLabel.setText("Verifying games...");
            this.progressBar.setMaximum(list.size() - 1);
            try {
                try {
                    missing = new PrintWriter(missingFileList);
                    int i = 0;
                    for (Item item : list) {
                        Game game3 = (Game)item;
                        this.progressBar.setValue(i);
                        this.progressLabel.setText("Verifying games... " + i + "/" + list.size());
                        game3.setFilename(game3.getFilename());
                        boolean found = Paths.getGamePath().exists(new File(game3.getFilename()));
                        if (!found) {
                            String correctFilename = Paths.getGamePath().findCorrectFilename(new File(game3.getFilename()));
                            boolean bl = found = correctFilename != null;
                            if (found) {
                                Const.log.warn((Object)("Game: correcting filename case '" + game3.getFilename() + "' to '" + correctFilename + "'"));
                                game3.setFilename(correctFilename);
                            }
                        }
                        game3.setGameFileExists(found);
                        if (!found) {
                            notFound.add(game3);
                            missing.println(game3.getFilename());
                            missing.flush();
                        }
                        if (this.status != 1) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    if (missing != null) {
                        missing.close();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (missing != null) {
                    missing.close();
                }
                throw throwable;
            }
            if (missing != null) {
                missing.close();
            }
        }
        this.gamesLabel.setText("Games found: " + (list.size() - notFound.size()) + "/" + list.size() + " specifying a game file of " + completeListSize + " total");
        this.out.println("Games not found: " + notFound.size() + "/" + list.size());
        notFound.forEach(game -> this.out.println("   " + game.getFilename() + "  (" + game.getName() + ")"));
        this.out.println();
        this.out.println();
        this.out.println();
        this.progressBar.setIndeterminate(true);
        this.progressLabel.setText("Writing to database...");
        Db.saveOrUpdateAll(list);
        this.setProgressBarFinished();
    }

    private void verifyMusic() {
        List<Item> list;
        ArrayList<Item> notFound;
        block19: {
            File missingFileList = new File(new File(Const.GBDIR_RW, Databases.getCurrent().getName()), "music.mfl");
            PrintWriter missing = null;
            missingFileList.delete();
            this.status = 2;
            notFound = new ArrayList<Item>();
            this.musicLabel.setText("");
            this.progressBar.setIndeterminate(true);
            this.out.println("VERIFY MUSIC");
            this.out.println("Paths:");
            ListerTools.fileListToStringList(Paths.getMusicPath().getWithDefault()).forEach(path -> this.out.println("  " + path));
            this.out.println();
            this.progressLabel.setText("Loading music...");
            ItemView view = new ItemView();
            view.setInclude(2);
            list = Db.getItems(view);
            Iterator<Item> iter = list.iterator();
            while (iter.hasNext()) {
                Item item2 = iter.next();
                if ((!(item2 instanceof Game) || !((Game)item2).getMusicFilename().isEmpty()) && (!(item2 instanceof Music) || !((Music)item2).getFilename().isEmpty())) continue;
                iter.remove();
            }
            this.musicLabel.setText(String.valueOf(list.size()) + " pieces of music loaded.");
            this.musicLabel.setText("Searching for " + list.size() + " pieces of music.");
            this.progressBar.setIndeterminate(false);
            this.progressLabel.setText("Verifying music...");
            try {
                try {
                    missing = new PrintWriter(missingFileList);
                    int i = 0;
                    for (Item item2 : list) {
                        String correctFilename;
                        boolean found;
                        this.progressBar.setValue(i);
                        this.progressLabel.setText("Verifying music... " + i + "/" + list.size());
                        if (item2 instanceof Game) {
                            Game game = (Game)item2;
                            game.setMusicFilename(game.getMusicFilename());
                            found = Paths.getMusicPath().exists(new File(game.getMusicFilename()));
                            if (!found) {
                                correctFilename = Paths.getMusicPath().findCorrectFilename(new File(game.getMusicFilename()));
                                boolean bl = found = correctFilename != null;
                                if (found) {
                                    Const.log.warn((Object)("Music(Game): correcting filename case '" + game.getMusicFilename() + "' to '" + correctFilename + "'"));
                                    game.setMusicFilename(correctFilename);
                                }
                            }
                            game.setMusicFileExists(found);
                            if (!found) {
                                notFound.add(game);
                                missing.println(game.getMusicFilename());
                                missing.flush();
                            }
                        }
                        if (item2 instanceof Music) {
                            Music music = (Music)item2;
                            music.setFilename(music.getFilename());
                            found = Paths.getMusicPath().exists(new File(music.getFilename()));
                            if (!found) {
                                correctFilename = Paths.getMusicPath().findCorrectFilename(new File(music.getFilename()));
                                boolean bl = found = correctFilename != null;
                                if (found) {
                                    Const.log.warn((Object)("Music: correcting filename case '" + music.getFilename() + "' to '" + correctFilename + "'"));
                                    music.setFilename(correctFilename);
                                }
                            }
                            music.setFileExists(found);
                            if (!found) {
                                notFound.add(music);
                                missing.println(music.getFilename());
                                missing.flush();
                            }
                        }
                        if (this.status != 1) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    if (missing != null) {
                        missing.close();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (missing != null) {
                    missing.close();
                }
                throw throwable;
            }
            if (missing != null) {
                missing.close();
            }
        }
        this.musicLabel.setText("Pieces of music found: " + (list.size() - notFound.size()) + "/" + list.size());
        this.out.println("Pieces of music not found: " + notFound.size() + "/" + list.size());
        notFound.forEach(item -> {
            String filename = "";
            if (item instanceof Game) {
                filename = ((Game)item).getMusicFilename();
            }
            if (item instanceof Music) {
                filename = ((Music)item).getFilename();
            }
            this.out.println("   " + filename + "  (" + item.getName() + ")");
        });
        this.out.println();
        this.out.println();
        this.out.println();
        this.progressBar.setIndeterminate(true);
        this.progressLabel.setText("Writing to database...");
        Db.saveOrUpdateAll(list);
        this.setProgressBarFinished();
    }

    private void verifyScreenshots() {
        List<Item> list;
        ArrayList<Game> notFound;
        block14: {
            File missingFileList = new File(new File(Const.GBDIR_RW, Databases.getCurrent().getName()), "screenshots.mfl");
            PrintWriter missing = null;
            missingFileList.delete();
            this.status = 2;
            notFound = new ArrayList<Game>();
            this.screenshotsLabel.setText("");
            this.progressBar.setIndeterminate(true);
            this.out.println("VERIFY SCREENSHOTS");
            this.out.println("Paths:");
            ListerTools.fileListToStringList(Paths.getScreenshotPath().getWithDefault()).forEach(path -> this.out.println("  " + path));
            this.out.println();
            this.progressLabel.setText("Loading screenshots...");
            ItemView view = new ItemView();
            view.setInclude(0);
            list = Db.getItems(view);
            Iterator<Item> iter = list.iterator();
            while (iter.hasNext()) {
                Game game2 = (Game)iter.next();
                if (!game2.getScreenshotFilename().isEmpty()) continue;
                iter.remove();
            }
            this.screenshotsLabel.setText(String.valueOf(list.size()) + " Screenshots loaded.");
            this.screenshotsLabel.setText("Searching for " + list.size() + " screenshots.");
            this.progressBar.setIndeterminate(false);
            this.progressLabel.setText("Verifying screenshots...");
            this.progressBar.setMaximum(list.size() - 1);
            try {
                try {
                    missing = new PrintWriter(missingFileList);
                    int i = 0;
                    for (Item item : list) {
                        Game game3 = (Game)item;
                        this.progressBar.setValue(i);
                        this.progressLabel.setText("Verifying screenshots... " + i + "/" + list.size());
                        game3.setScreenshotFilename(game3.getScreenshotFilename());
                        boolean found = Paths.getScreenshotPath().exists(new File(game3.getScreenshotFilename()));
                        if (!found) {
                            String correctFilename = Paths.getScreenshotPath().findCorrectFilename(new File(game3.getScreenshotFilename()));
                            boolean bl = found = correctFilename != null;
                            if (found) {
                                Const.log.warn((Object)("Screenshot: correcting filename case '" + game3.getScreenshotFilename() + "' to '" + correctFilename + "'"));
                                game3.setScreenshotFilename(correctFilename);
                            }
                        }
                        if (!found) {
                            notFound.add(game3);
                            missing.println(game3.getScreenshotFilename());
                            missing.flush();
                        }
                        if (this.status != 1) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    if (missing != null) {
                        missing.close();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (missing != null) {
                    missing.close();
                }
                throw throwable;
            }
            if (missing != null) {
                missing.close();
            }
        }
        this.screenshotsLabel.setText("Screenshots found: " + (list.size() - notFound.size()) + "/" + list.size());
        this.out.println("Screenshots not found: " + notFound.size() + "/" + list.size());
        notFound.forEach(game -> this.out.println("   " + game.getScreenshotFilename() + "  (" + game.getName() + ")"));
        this.out.println();
        this.out.println();
        this.out.println();
        this.setProgressBarFinished();
    }

    private void verifyExtras() {
        List<Extra> list;
        ArrayList<Game> gameList;
        ArrayList<Extra> notFound;
        block16: {
            File missingFileList = new File(new File(Const.GBDIR_RW, Databases.getCurrent().getName()), "extras.mfl");
            PrintWriter missing = null;
            missingFileList.delete();
            this.status = 2;
            notFound = new ArrayList<Extra>();
            gameList = new ArrayList<Game>();
            this.extrasLabel.setText("");
            this.progressBar.setIndeterminate(true);
            this.out.println("VERIFY EXTRAS");
            this.out.println("Paths:");
            ListerTools.fileListToStringList(Paths.getExtraPath().getWithDefault()).forEach(path -> this.out.println("  " + path));
            this.out.println();
            this.progressLabel.setText("Loading extras...");
            list = Db.getExtras();
            Iterator<Extra> iter = list.iterator();
            while (iter.hasNext()) {
                Extra extra2 = iter.next();
                if (!extra2.getFilename().isEmpty()) continue;
                iter.remove();
            }
            this.extrasLabel.setText(String.valueOf(list.size()) + " Extras loaded.");
            this.extrasLabel.setText("Searching for " + list.size() + " extras.");
            this.progressBar.setIndeterminate(false);
            this.progressLabel.setText("Verifying extras...");
            this.progressBar.setMaximum(list.size() - 1);
            try {
                try {
                    missing = new PrintWriter(missingFileList);
                    int i = 0;
                    for (Extra extra2 : list) {
                        this.progressBar.setValue(i);
                        this.progressLabel.setText("Verifying extras... " + i + "/" + list.size());
                        extra2.setFilename(extra2.getFilename());
                        boolean found = false;
                        found = extra2.isUrl() ? true : Paths.getExtraPath().exists(new File(extra2.getFilename()));
                        if (!found) {
                            String correctFilename = Paths.getExtraPath().findCorrectFilename(new File(extra2.getFilename()));
                            boolean bl = found = correctFilename != null;
                            if (found) {
                                Const.log.warn((Object)("Extra: correcting filename case '" + extra2.getFilename() + "' to '" + correctFilename + "'"));
                                extra2.setFilename(correctFilename);
                            }
                        }
                        extra2.setEnabled(found);
                        if (!found) {
                            notFound.add(extra2);
                            missing.println(extra2.getFilename());
                            missing.flush();
                        } else {
                            Game game = Db.getGameById(extra2.getGameId());
                            if (game != null) {
                                game.setHasExtras(true);
                                gameList.add(game);
                            }
                        }
                        if (this.status != 1) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    if (missing != null) {
                        missing.close();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (missing != null) {
                    missing.close();
                }
                throw throwable;
            }
            if (missing != null) {
                missing.close();
            }
        }
        this.extrasLabel.setText("Extras found: " + (list.size() - notFound.size()) + "/" + list.size());
        this.out.println("Extras not found: " + notFound.size() + "/" + list.size());
        notFound.forEach(extra -> this.out.println("   " + extra.getFilename() + "  (" + extra.getName() + ")"));
        this.progressBar.setIndeterminate(true);
        this.progressLabel.setText("Writing to database...");
        Db.saveOrUpdateAll(list);
        Db.saveOrUpdateAll(gameList);
        this.setProgressBarFinished();
    }

    private void setProgressBarFinished() {
        this.progressLabel.setText("");
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMaximum(100);
        this.progressBar.setValue(100);
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.cancel();
    }
}

